/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       MAIN.C               											
*														              					
* Description:	  Main Source Code for MC9S08DZ60	        	    	
*                 based on Specification Rev. 3  	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/		

#pragma MESSAGE DISABLE C1825 /* WARNING C1825 */          

/* include files */
#include "derivative.h" /* include peripheral declarations */
#include <hidef.h>      /* for EnableInterrupts macro */
#include "target.h"     /* include target header */
#include "flash_drv.h"  /* include flash declarations */
#include "sci_drv.h"    /* include sci declarations */

/* Definintions */

byte void Sector_Erase_Routine(void);
byte void Byte_Program_Routine(void);
byte void Burst_Program_Routine(void);
void CheckReturn(byte Return);
void InitialiseMCU(void);

byte data[] = "This is a FLASH BURST PROGRAM example! This is a FLASH BURST PROGRAM example! This is a FLASH BURST PROGRAM example! This is a FLASH BURST PROGRAM example! This is a FLASH BURST PROGRAM example! This is a FLASH BURST PROGRAM example! This is a FLASH BURST";
byte datum [] = "This is a FLASH BYTE PROGRAM example! This is a FLASH BYTE PROGRAM example! This is a FLASH BYTE PROGRAM example! This is a FLASH BYTE PROGRAM example! This is a FLASH BYTE PROGRAM example! This is a FLASH BYTE PROGRAM example! This is a FLASH BYTE PROGRAM";

void main(void) {

byte error = 0;
byte Return;

SOPT1 = 0x00;               /* Disable COP */
SOPT2 = 0x01;               /* Disable MCLK output */
SPMSC1 = 0x00;              /* Disable LVD */
SPMSC2 = 0x00;

DisableInterrupts;


InitialiseMCU();

//DisableInterrupts;    

while(FOREVER)
  {
    LF;
    DisplayString("Main Menu:\r\n");
    DisplayString("  1: Blank Check\r\n");
    DisplayString("  2: Sector Erase\r\n");
    DisplayString("  3: Mass Erase\r\n");
    DisplayString("  4: Byte Programming\r\n");
    DisplayString("  5: Burst Progamming\r\n");
    DisplayString("  6: Sector Erase Abort\r\n");
    
    DisplayString("\nSelect number to execute: ");

    switch (EchoGetChar())  
    {
      case one: 
        LF;
        DisplayString("Performing Blank Check Procedure.");
        LF;
         
        Return = Blank_Check();          
      
        CheckReturn(Return);
        
        if(Return & FLASH_BLANK) 
            {
            LF; 
            DisplayString("Flash Memory Is Blank.");
            LF;
            }
        else
            {
            LF; 
            DisplayString("Flash Memory Is Not Blank.");
            LF;
            }  
        break;
      
      case two:
        LF;
        DisplayString("Performing Sector Erase Procedure.");
        LF;
        
        Return = Sector_Erase_Routine();
        
        CheckReturn(Return);
  
       break;
      
      case three: 
        LF;
        DisplayString("Performing Mass Erase Procedure.");
        LF;

        Return = Mass_Erase();
        
        CheckReturn(Return);

        break;
        
      case four: 
        LF;
        DisplayString("Performing Byte Programming Procedure.");
        LF;
        
        Return = Byte_Program_Routine();
        
        CheckReturn(Return);
        
      break;
      
      case five:
      
        LF;
        DisplayString("Performing Burst Programming Procedure.");
        LF; 
        
        Return = Burst_Program_Routine();
        
        CheckReturn(Return);
         
        break; 
     
        case six:
        LF;
        DisplayString("Performing Sector Erase Abort Procedure.");
        LF;
        
        Return = Sector_Erase_Abort();
        
        CheckReturn(Return);
 
        break;
        
        default: DisplayString("\nInvalid selection\r\n");
        
      } //end switch */
      LF;
      DisplayString("\n\rPress any key to continue:");
      (void)EchoGetChar();
      FF;       
  } //end while
} //end main   


/******************************************************************************
Function Name	:	InitialiseMCU
Parameters		:	NONE
Returns			  :	None
Notes			    : Configures the port pins and clocks, selects SCI1 for 
                communications with terminal program and sets FDIV value
******************************************************************************/
void InitialiseMCU(void) {

/* Initialise all port pins as inputs with pullups enabled */
PTAPE = 0xFF;
PTBPE = 0xFF;
PTCPE = 0xFF;
PTDPE = 0xFF;
PTEPE = 0xFF;
PTFPE = 0xFF;
PTGPE = 0x3F;

/* Configure MCG to produce a 20MHz bus clock from a 8MHz external crystal */

MCGC2 = 0x36;               /* High frequency range, high gain, external crystal selected, reference clock activated */
while(MCGSC_OSCINIT != 1);  /* Wait until crystal has been initialised */

MCGC1 = 0xB8;               /* Select the external reference clock as the system clock, 
                               divide external reference frequency by 128 */
                               
                        
while(MCGSC_IREFST != 0);   /* Wait here until the external reference is selected as the reference clock source */
while(MCGSC_CLKST != 0b10); /* Wait here until the external reference is selected to feed MCGOUT */

MCGC2 = 0x3E;               /* Enter BLPE mode by setting the LP bit */

MCGC1 = 0x98;               /* Select external reference clock, divide reference clock by 8 */
MCGC3 = 0x4A;               /* Select the PLL, multiply reference clock by 40 */
while(MCGSC_PLLST != 1);    /* Wait here until the PLL is selected as the PLLS clock source */

MCGC2 = 0x36;               /* Enter BPE mode by clearing the LP bit */

while(MCGSC_LOCK != 1);     /* Wait here until the PLL has acquired lock */

MCGC1 = 0x18;               /* Select the PLL as the system clock source */
while(MCGSC_CLKST != 0b11); /* Wait here until the PLL is selected to feed MCGOUT */


TerminalPointer = &SCI1;    /* Select SCI1 for communications with terminal program */
SCI_Config(&SCI1, SCIBD_BAUD_RATE);  /* Configure SCI1 to communicate at 57600 Baud */
FF;

FLASH_FDIV_20M;             /* Select divisor to generate required program/erase timing pulse */

}

/******************************************************************************
Function Name	:	Byte_Program_Routine
Parameters		:	i, error, Result, *FlashDataPtr
Returns			  :	Result
Notes			    : Calls the Byte Programming Routine within the flash_drv.c file
******************************************************************************/
byte Byte_Program_Routine() 
{
  word i;
  byte error = 0,Result,*FlashDataPtr=0;
  
  FlashDataPtr = (byte *)FLASH_START;

  Result = Byte_Program(FlashDataPtr, datum, FLASH_BURST_SIZE);   
        
  /* Check that Flash is programmed with expected value */
  for (i = 0; ((i < FLASH_BURST_SIZE) && (!(Result & FLASH_PROG_DATAERR))); i++)         
    {
    if (*FlashDataPtr++ != datum[i])  /* If not, flag an error */
      {
      Result |= FLASH_PROG_DATAERR;                                    
      }
    }
  
  return Result;
}
  
/******************************************************************************
Function Nane	:	Burst_Program_Routine
Parameters		:	i, error, Result, *FlashDataPtr
Returns			  :	Result
Notes			    : Calls the Burst Programming Routine within the flash_drv.c file
******************************************************************************/
byte Burst_Program_Routine(void)
{
  word i;
  byte error = 0,Result,*FlashDataPtr=0;
 
  FlashDataPtr = (byte *)FLASH_START;
  
  Result = Burst_Program(FlashDataPtr, data, FLASH_BURST_SIZE); 

  /* Check that Flash is programmed with expected value */
  for (i = 0; ((i < FLASH_BURST_SIZE) && (!(Result & FLASH_PROG_DATAERR))); i++)         
    {
    if (*FlashDataPtr++ != data[i])   /* If not, flag an error */
      {
      Result |= FLASH_PROG_DATAERR;
      }
    }

  return Result;
}
    
/******************************************************************************
Function Name	:	Sector_Erase_Routine
Parameters		:	i, Result
Returns			  :	Result
Notes			    : Calls the Sector Erase Routine within the flash_drv.c file
******************************************************************************/
byte Sector_Erase_Routine(void)
{
  word i;
  byte Result = 0;
  
  Result= Sector_Erase((byte *)FLASH_START);
 
  /* Check that sector is erased */
  for (i = 0; ((i < FLASH_SECTOR_SIZE) && (!(Result & FLASH_SECTOR_ERASEERR))); i++)         
    {
    if (*(byte *)(FLASH_START + i) != 0xFF)       /* If not, flag an error */
      { 
      Result |= FLASH_SECTOR_ERASEERR;
      }
    }
          
  return Result;
}
  
/******************************************************************************
Function Name	:	CheckReturn
Parameters		:	Return
Returns			  :	None
Notes			    : Checks the return value of the flash driver and writes the status
                to the terminal program.
******************************************************************************/
void CheckReturn(byte Return)
{

  /* Clear Flash blank flag */
  Return &= ~FLASH_BLANK;
  
  if(Return == FLASH_OK)
    {
    /* Success */
    DisplayString("Procedure has been completed successfully.");
    LF;
    }
  else 
    {
       
    if(Return & FLASH_FACCERR) 
      {
      DisplayString("FSTAT_FACCERR is set!!!");
      LF;
      }
    if(Return & FLASH_FPVIOL)
      {
      DisplayString("FSTAT_FPVIOL is set!!!");
      LF;
      }
    
    if(Return & FLASH_SECTOR_ERASEERR) 
      {
      LF; 
      DisplayString("Sector Erase Procedure Has Failed.");
      LF;
      }
          
    if(Return & FLASH_PROG_DATAERR) 
      {
      LF; 
      DisplayString("An Error Has Occurred During Programming Procedure.");
      LF;
      }
    
    if(Return & SECTOR_ERASED) 
      {
      LF; 
      DisplayString("Sector Erase Abort Procedure Has Failed.");
      LF;
      }  
      
    }
}
  